@../params.sql
-- umoznime pouzitie inicializacnych parametrov
set define on
set echo on

prompt Prihlasime sa ako pouzivatel client
connect client/&client_pass&db_name

set echo off
prompt Nastavime namespace na bank_is, aby sme nemuseli pouzivat prefixy
pause Pre pokracovanie stlacte Enter
set echo on
alter session set current_schema=bank_is;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Autentifikujeme sa do systemu
pause Pre pokracovanie stlacte Enter
set echo on
begin
 client_context_pkg.init_context('rgolian', -- meno  
                                   sys.dbms_crypto.hash(sys.utl_i18n.string_to_raw('rgolianheslo', 'AL32UTF8') || 
                                                        client_context_pkg.get_salt('rgolian'), 
                                                        sys.dbms_crypto.HASH_SH1)); -- SHA-1(heslo || sol) 
end;
/

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pozrieme si informacie o nasom ucte - mame nastaveny kontext
pause Pre pokracovanie stlacte Enter
set echo on
select * from v_all_client;


set echo off
pause Pre pokracovanie stlacte Enter
prompt Pozrieme sa ake konta mame k dispozicii
pause Pre pokracovanie stlacte Enter
set echo on
select * from v_all_account;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Nastavime ucet, nad ktorym budeme vykonavat operacie
pause Pre pokracovanie stlacte Enter
set echo on

execute client_context_pkg.set_account_no('0123456787')

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pokusime sa vykonat platbu na ktoru nemame pravo - TELLER_PAY
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context', 'account_no'), '0000005555', '123', 500, sysdate, 'NEW', 'TELLER_PAY');


set echo off
pause Pre pokracovanie stlacte Enter
prompt zobrazime denny limit pre platbu EBANK a stav na ucte
pause Pre pokracovanie stlacte Enter
set echo on
select vaa.day_limit, vaa.balance from v_all_account vaa 
where vaa.account_no = sys_context('bank_context','account_no');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Pokusime sa o palatbu nad denny limit
pause Pre pokracovanie stlacte Enter
set echo on
insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context', 'account_no'), '0000005555', '111111', 3001, sysdate, 'NEW', 'EBANK_PAY');


set echo off
pause Pre pokracovanie stlacte Enter
prompt Pokusime sa o palatbu nad denny limit pomocou viacerych transakcii
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context', 'account_no'), '0000005555', '111111', 2500, sysdate, 'NEW', 'EBANK_PAY');

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context', 'account_no'), '0000005555', '111111', 600, sysdate, 'NEW', 'EBANK_PAY');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Zobrazime transakcie
pause Pre pokracovanie stlacte Enter
set echo on
select * from v_all_transaction;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Nastavime iny ucet
pause Pre pokracovanie stlacte Enter
set echo on

execute client_context_pkg.set_account_no('0123456789')

set echo off
pause Pre pokracovanie stlacte Enter
prompt zobrazime denny limit pre platbu EBANK a stav na ucte
pause Pre pokracovanie stlacte Enter
set echo on
select vaa.day_limit, vaa.balance from v_all_account vaa 
where vaa.account_no = sys_context('bank_context','account_no');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Skusime vykonat platbu vyzadujucu vacsie prostredky ake su na ucte
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_all_i_transaction(id,account_from,account_to,var_sym,amount,created,status,trans_type)
values (seq_transaction_id.nextval, sys_context('bank_context', 'account_no'), '0000005555', '111111', 5000,sysdate, 'NEW', 'EBANK_PAY');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Zobrazime karty k uctu 
pause Pre pokracovanie stlacte Enter
set echo on

select * from v_all_card;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vyskusame este preddefinovane platby - pridame dve preddefinovane platby
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_client_predefined_payment(id,client_id,account_to,var_symb,note,payment_name)
values (seq_predefined_payment_id.nextval, sys_context('bank_context', 'client_id'), '0011223344', '2007', 'Poznamka1', 'Nazov platby1');

insert into v_client_predefined_payment(id,client_id,account_to,var_symb,note,payment_name)
values (seq_predefined_payment_id.nextval, sys_context('bank_context', 'client_id'), '0011223344', '2007', 'Poznamka2', 'Nazov platby2');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Skusime vytvorit preddefinovanu platbu pre ineho pouzivatela
pause Pre pokracovanie stlacte Enter
set echo on

insert into v_client_predefined_payment(id,client_id,account_to,var_symb,note,payment_name)
values (seq_predefined_payment_id.nextval, 2, '0011223344', '2007', 'Poznamka3', 'Nazov platby3');

set echo off
pause Pre pokracovanie stlacte Enter
prompt Modifikujeme poznamky vo vsetkych platbach tak, ze pridame na koniec bodku. 
prompt Zmena sa bude tykat iba nasich platieb.
pause Pre pokracovanie stlacte Enter
set echo on

update v_client_predefined_payment
set note = note || '.';


set echo off
pause Pre pokracovanie stlacte Enter
prompt Pozrieme si nase preddefinovane platby
pause Pre pokracovanie stlacte Enter
set echo on

select * from v_client_predefined_payment;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Vymazeme vsetky nase preddefinovane platby
pause Pre pokracovanie stlacte Enter
set echo on

delete from v_client_predefined_payment;

set echo off
pause Pre pokracovanie stlacte Enter
prompt Zmeny neaplikujeme do DB
pause Pre pokracovanie stlacte Enter
set echo on
rollback;

pause Pre pokracovanie stlacte Enter
prompt Ukoncime spojenie
exit


